# Database Migrations

This directory contains database migration scripts for the Contracts and Views system.

## Migration: 001_update_scenes_table.sql

**Purpose**: Break the relation between contracts and scenes by making contractId optional and adding facility fields directly to scenes table.

### Changes Made:
1. **Made contractId nullable** - Scenes can now exist without being linked to a contract
2. **Added facility fields**:
   - `facilityName` - Name of the facility/establishment
   - `facilityOwnerName` - Name of the facility owner
   - `ownerNationalID` - National ID of the owner
   - `facilityLocation` - Location of the facility
   - `internalCameras` - Number of internal cameras
   - `externalCameras` - Number of external cameras

3. **Updated foreign key constraint** - Changed from CASCADE to SET NULL on contract deletion
4. **Added indexes** for new fields to improve query performance
5. **Data migration** - Existing scenes will have their facility fields populated from their linked contracts

### How to Run the Migration:

#### Option 1: Using the Node.js migration runner
```bash
cd server/migrations
node run-migration.js
```

#### Option 2: Manual SQL execution
1. Connect to your MySQL database
2. Execute the SQL commands in `001_update_scenes_table.sql` file

### Important Notes:
- **Backup your database** before running this migration
- This migration will modify the `scenes` table structure
- Existing data will be preserved and migrated appropriately
- After migration, scenes can be created with or without linking to contracts
- The frontend has been updated to support the new structure

### Rollback:
If you need to rollback this migration, you would need to:
1. Remove the new facility fields from scenes table
2. Make contractId NOT NULL again
3. Ensure all scenes have valid contractId values
4. Restore the CASCADE foreign key constraint

**Note**: A rollback script is not provided as it would require careful handling of data that was created after the migration.

### Testing After Migration:
1. Verify that existing scenes still display correctly
2. Test creating new scenes with contracts (facility data should auto-populate)
3. Test creating new scenes without contracts (manual facility data entry)
4. Verify that deleting contracts sets contractId to NULL in related scenes instead of deleting them
